/*
 * Carrega.java
 *
 * Created on 10 de junio de 2008, 15:41
 */

package servlets;

import entitats.Client;
import java.io.*;
import java.net.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;
import locals.Local;
import locals.Zona;

/**
 *
 * @author dai
 * @version
 */
public class Carrega extends HttpServlet {
    
    Connection con = null;
    DataSource ds = null;
    ArrayList <Local> locals = new ArrayList();
    ArrayList <Zona> zones = new ArrayList();
    ArrayList <Client> clients = new ArrayList();
    Local local = new Local();
    Zona zona = new Zona();
    Client client = new Client();
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        
        try {
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            
            locals.clear();
            zones.clear();
            clients.clear();
            
            if (request.getParameter("client") != null)
                if (request.getParameter("client").equals("1")) {
                carregaPropietaris(request);
                request.setAttribute("Client", clients);
                }
            
            if (request.getParameter("clients") != null)
                if (request.getParameter("clients").equals("1")) {
                carregaPropietaris(request);
                request.setAttribute("clients", clients);
                }
            
            if (request.getParameter("zones") != null) 
            if (request.getParameter("zones").equals("1")) {
                carregaZones();
                request.setAttribute("zones", zones);
            }
            
            if (request.getParameter("idlocal") != null) {
                carregaLocal(Integer.parseInt(request.getParameter("idlocal")));
                request.setAttribute("Local", local);
            }
            
            if (request.getParameter("locals") != null) {
                carregaLocals(Integer.parseInt(request.getParameter("locals")));
                request.setAttribute("locals", locals);
                }
            
            
            RequestDispatcher rD = null;
            if (request.getParameter("action") != null){
                if (request.getParameter("action").equals("baixa_propietari"))
                    rD = request.getRequestDispatcher("/baixa_client.jsp");
                if (request.getParameter("action").equals("edicio_client"))
                    rD = request.getRequestDispatcher("/modificacio_client.jsp");
                if (request.getParameter("action").equals("alta_local"))
                    rD = request.getRequestDispatcher("/alta_local.jsp");
                if (request.getParameter("action").equals("baixa_local"))
                    rD = request.getRequestDispatcher("/baixa_local.jsp");
                if (request.getParameter("action").equals("aprovar_local"))
                    rD = request.getRequestDispatcher("/aprovar_local.jsp");
            }
            
            rD.forward(request, response);
            out.close();
            
        } catch(Exception e) {
            System.out.println("ERROR: "+e.getMessage());
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){}
        }
        
        
        /*if (request.getParameter("action").equals("alta_local"))
            rD = request.getRequestDispatcher("/alta_local.jsp");
        else if (request.getParameter("action").equals("alta_llogater"))
            rD = request.getRequestDispatcher("/alta_propietari.jsp");*/
        /*else if (request.getParameter("action").equals("modificacio_local"))
            rD = request.getRequestDispatcher()*/
    }
    
    
    /*Metodes de carrega*/
    protected void carregaZones() {
        try {
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM zones");
            while ( rs.next() ) {
                zones.add(new Zona(rs.getInt("id"), rs.getString("zona"), rs.getString("descripcio")));
            }
            rs.close();
            st.close();
            con.close();
        } catch(Exception e) {
            System.out.println("ERROR: "+e.getMessage());
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){}
        }
    }
    
    protected void carregaPropietaris(HttpServletRequest request) {
        try {
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            clients.clear();
            
            String idClient = request.getParameter("id");
            Client c = new Client();
            c = (Client) request.getAttribute("Client");
            
            //Omple els camps del client que es podran modificar
            if (request.getParameter("id") != null){
                rs = st.executeQuery("SELECT * FROM clients WHERE id = "+idClient);
                rs.next();
                Client client = new Client();
                client.setIdClient(rs.getInt("id"));
                client.setNif(rs.getString("nif"));
                client.setNom(rs.getString("nom_o_rao_social"));
                if (rs.getString("cognoms") != null)
                    client.setCognoms(rs.getString("cognoms"));
                client.setTelefon(rs.getString("telefon"));
                client.setAdresa(rs.getString("adresa"));
                if (request.getAttribute("Client") != null)
                    client.setError(c.getError());
                request.setAttribute("Client", client);
            }
            
            //Comprova si hi ha algun atribut clients, i si no hi es omple un arraylist per mostrar tots els clients
            if ( request.getAttribute("clients") == null) {
                request.removeAttribute("client");
                Client client = new Client();
                
                if (request.getSession().getAttribute("usuariagent") != null)
                    rs = st.executeQuery("SELECT * FROM clients WHERE es_propietari = 1");
                else if (request.getSession().getAttribute("usuarivenedor") != null)
                    rs = st.executeQuery("SELECT * FROM clients WHERE es_llogater = 1");
                while (rs.next()) {
                    clients.add(new Client(rs.getInt("id"), rs.getString("nif"), rs.getString("nom_o_rao_social"), rs.getString("cognoms")));
                }
                
                rs.close();
                st.close();
                con.close();
            }
        } catch(Exception e) {
            System.out.println("SERVLET ERROR: " +e.getMessage() );
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){}
        }
    }
    
    protected void carregaLocals(int actiu) {
        try {
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE actiu = "+actiu);
            while ( rs.next() ) {
                locals.add(new Local(rs.getString("codi_local"), rs.getInt("id"), rs.getString("adresa")));
            }
            rs.close();
            st.close();
            con.close();
        } catch(Exception e) {
            System.out.println("ERROR: "+e.getMessage());
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){}
        }
    }
    
    protected void carregaLocal(int idLocal) {
        try {
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE id = "+idLocal);
            if ( rs.next() ) {
                local.setAdresa(rs.getString("adresa"));
                local.setCaracteristiques(rs.getString("caracteristiques"));
                local.setCaracteristiquesPolivalents(rs.getString("caracteristiques_polivalent"));
                local.setCodiLocal(rs.getString("codi_local"));
                local.setIdLocal(idLocal);
                local.setIdPropietari(rs.getInt("id_propietari"));
                local.setPreu(rs.getFloat("preu"));
                local.setRestriccions(rs.getString("restriccions"));
                local.setSuperficie(rs.getFloat("superficie"));
                local.setTipus(rs.getString("tipus"));
                local.setVolum(rs.getFloat("volum"));
                local.setIdZona(rs.getInt("id_zona"));
            }
            
            rs.close();
            st.close();
            con.close();
        } catch(Exception e) {
            System.out.println("ERROR: "+e.getMessage());
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){}
        }
    }
    
// <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        //this.doGet(request, response);
        processRequest(request, response);
        
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
// </editor-fold>
}
